var S=Object.defineProperty;var z=(f,e,t)=>e in f?S(f,e,{enumerable:!0,configurable:!0,writable:!0,value:t}):f[e]=t;var a=(f,e,t)=>z(f,typeof e!="symbol"?e+"":e,t);const u=class u{constructor(e){a(this,"file");a(this,"targetPath");a(this,"chunkSize");a(this,"maxRetries");a(this,"onProgress");a(this,"onChunkProgress");a(this,"onDetailProgress");a(this,"onError");a(this,"signal");a(this,"conflictStrategy");a(this,"uploadId");a(this,"chunks",[]);a(this,"uploadedChunks",new Set);a(this,"uploadStartTime",0);a(this,"uploadedSize",0);a(this,"retryCount",new Map);a(this,"aborted",!1);a(this,"currentChunk",0);a(this,"currentBatch",0);a(this,"totalBatches",0);a(this,"chunksProgressMap",new Map);this.file=e.file,this.targetPath=e.targetPath,this.chunkSize=e.chunkSize||u.DEFAULT_CHUNK_SIZE,this.maxRetries=e.maxRetries||u.MAX_RETRIES,this.onProgress=e.onProgress,this.onChunkProgress=e.onChunkProgress,this.onDetailProgress=e.onDetailProgress,this.onError=e.onError,this.signal=e.signal,this.conflictStrategy=e.conflictStrategy||"rename",this.uploadId=this.generateUploadId(),this.signal&&this.signal.addEventListener("abort",()=>{this.aborted=!0})}formatSize(e){if(e===0)return"0 B";const t=1024,r=["B","KB","MB","GB"],s=Math.floor(Math.log(e)/Math.log(t));return(e/Math.pow(t,s)).toFixed(2)+" "+r[s]}formatSpeed(e){return this.formatSize(e)+"/s"}formatTime(e){return e<60?`${Math.round(e)}秒`:e<3600?`${Math.round(e/60)}分钟`:`${Math.round(e/3600)}小时`}updateChunkProgress(e,t,r=0,s=0){const i=this.chunks[e];if(!i)return;const o=this.chunksProgressMap.get(e)||{chunkIndex:e,status:"pending",progress:0,size:i.chunkSize,uploadedSize:0};this.chunksProgressMap.set(e,{...o,status:t,progress:r,uploadedSize:s,retryCount:this.retryCount.get(e)})}sendDetailProgress(e,t,r){if(!this.onDetailProgress)return;const s=Date.now()-this.uploadStartTime,i=s>0?this.uploadedSize/s*1e3:0,o=this.file.size-this.uploadedSize,n=i>0?o/i:0,l=this.file.size>0?Math.round(this.uploadedSize/this.file.size*100):0,d=Array.from(this.chunksProgressMap.values()).sort((g,k)=>g.chunkIndex-k.chunkIndex);this.onDetailProgress({phase:e,phaseText:t,currentChunk:this.currentChunk,totalChunks:this.chunks.length,uploadedChunks:this.uploadedChunks.size,uploadedSize:this.uploadedSize,totalSize:this.file.size,percentage:l,speed:i,speedText:this.formatSpeed(i),remainingTime:n,remainingTimeText:this.formatTime(n),currentBatch:this.currentBatch,totalBatches:this.totalBatches,chunksProgress:d,...r})}generateUploadId(){return`upload_${this.file.name}_${this.file.size}_${Date.now()}`}async calculateChunks(){const e=Math.ceil(this.file.size/this.chunkSize);this.chunks=[];for(let t=0;t<e;t++){const r=t*this.chunkSize,s=Math.min(r+this.chunkSize,this.file.size),i=this.file.slice(r,s),o=await this.calculateHash(i);this.chunks.push({chunkIndex:t,chunkSize:s-r,start:r,end:s,hash:o}),this.updateChunkProgress(t,"pending",0,0)}}async calculateHash(e){try{if(!crypto||!crypto.subtle||!crypto.subtle.digest)return console.warn("crypto.subtle 不可用，跳过hash计算"),"skip";const t=await e.arrayBuffer(),r=await crypto.subtle.digest("SHA-256",t);return Array.from(new Uint8Array(r)).map(i=>i.toString(16).padStart(2,"0")).join("")}catch(t){return console.warn("计算hash失败，跳过hash计算:",t),"skip"}}async checkUploadedChunks(){try{const e=localStorage.getItem("gsm3_token"),t=await fetch("/api/files/upload/check",{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Bearer ${e}`},body:JSON.stringify({uploadId:this.uploadId,fileName:this.file.name,fileSize:this.file.size,totalChunks:this.chunks.length})});if(t.ok){const r=await t.json();r.uploadedChunks&&Array.isArray(r.uploadedChunks)&&(r.uploadedChunks.forEach(s=>{this.uploadedChunks.add(s);const i=this.chunks[s];i&&(this.uploadedSize+=i.chunkSize)}),console.log(`断点续传: 已上传 ${this.uploadedChunks.size}/${this.chunks.length} 个分片`))}}catch(e){console.warn("检查已上传分片失败，将从头开始上传:",e)}}async uploadChunk(e){if(this.aborted)throw new Error("Upload aborted");const{chunkIndex:t,start:r,end:s,hash:i}=e,o=this.file.slice(r,s),n=new FormData;n.append("uploadId",this.uploadId),n.append("fileName",this.file.name),n.append("fileSize",this.file.size.toString()),n.append("chunkIndex",t.toString()),n.append("totalChunks",this.chunks.length.toString()),n.append("chunkHash",i),n.append("targetPath",this.targetPath);const l=new Blob([o],{type:"application/octet-stream"}),d=`${this.file.name}.part${t}`;n.append("chunk",l,d);const g=localStorage.getItem("gsm3_token");return new Promise((k,p)=>{const h=new XMLHttpRequest;h.upload.addEventListener("progress",c=>{if(c.lengthComputable){const m=c.loaded/c.total*100;this.updateChunkProgress(t,"uploading",m,c.loaded),this.sendDetailProgress("uploading",`正在上传分片 ${t+1}/${this.chunks.length}`),this.onChunkProgress&&this.onChunkProgress(t,this.chunks.length,m)}}),h.addEventListener("load",()=>{if(h.status>=200&&h.status<300)try{const c=JSON.parse(h.responseText);c.success?(this.uploadedChunks.add(t),this.uploadedSize+=e.chunkSize,this.updateProgress(),k()):p(new Error(c.message||"分片上传失败"))}catch{p(new Error("解析响应失败"))}else p(new Error(`HTTP ${h.status}: ${h.statusText}`))}),h.addEventListener("error",()=>{p(new Error("网络错误"))}),h.addEventListener("abort",()=>{p(new Error("上传已取消"))}),h.timeout=u.CHUNK_UPLOAD_TIMEOUT,h.addEventListener("timeout",()=>{p(new Error("上传超时，请检查网络连接"))}),this.signal&&this.signal.addEventListener("abort",()=>{h.abort()}),h.open("POST","/api/files/upload/chunk"),g&&h.setRequestHeader("Authorization",`Bearer ${g}`),h.send(n)})}async uploadChunkWithRetry(e){const{chunkIndex:t}=e;let r=null;this.currentChunk=t;for(let s=0;s<=this.maxRetries;s++)try{if(this.aborted)throw new Error("Upload aborted");this.updateChunkProgress(t,"uploading",0,0),this.sendDetailProgress("uploading",`正在上传分片 ${t+1}/${this.chunks.length}`),await this.uploadChunk(e),this.retryCount.delete(t),this.updateChunkProgress(t,"completed",100,e.chunkSize),this.sendDetailProgress("uploading",`分片 ${t+1} 上传完成`),t%10===0&&await new Promise(i=>setTimeout(i,100));return}catch(i){r=i;const o=s+1;if(this.retryCount.set(t,o),this.updateChunkProgress(t,s<this.maxRetries?"retrying":"error",0,0),s<this.maxRetries){const n=u.RETRY_BASE_DELAY*Math.pow(2,s),l=Math.random()*1e3,d=Math.min(n+l,3e4);console.warn(`分片 ${t} 上传失败（${r==null?void 0:r.message}），${d.toFixed(0)}ms 后进行第 ${o} 次重试...`),this.sendDetailProgress("uploading",`分片 ${t+1} 重试中...`,{retryInfo:{chunkIndex:t,retryCount:o,maxRetries:this.maxRetries}}),await new Promise(g=>setTimeout(g,d))}else{const n=this.chunksProgressMap.get(t);n&&(n.error=r==null?void 0:r.message)}}throw new Error(`分片 ${t} 上传失败，已重试 ${this.maxRetries} 次: ${r==null?void 0:r.message}`)}updateProgress(){if(this.onProgress){const e=Math.round(this.uploadedSize/this.file.size*100);this.onProgress(e)}}async mergeChunks(){const e=localStorage.getItem("gsm3_token");(async()=>{for(let o=0;o<=100&&!this.aborted;o+=10)this.sendDetailProgress("merging","正在合并文件...",{mergingProgress:o}),await new Promise(n=>setTimeout(n,100))})();const s=await fetch("/api/files/upload/merge",{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Bearer ${e}`||""},body:JSON.stringify({uploadId:this.uploadId,fileName:this.file.name,fileSize:this.file.size,totalChunks:this.chunks.length,targetPath:this.targetPath,conflictStrategy:this.conflictStrategy})});if(this.sendDetailProgress("merging","正在合并文件...",{mergingProgress:100}),!s.ok){const o=await s.json().catch(()=>({}));throw new Error(o.message||"合并文件失败")}const i=await s.json();if(!i.success)throw new Error(i.message||"合并文件失败")}async upload(){try{this.uploadStartTime=Date.now(),this.sendDetailProgress("preparing","正在准备上传..."),console.log(`开始分片上传: ${this.file.name} (${(this.file.size/1024/1024).toFixed(2)} MB)`),await this.calculateChunks(),console.log(`文件已分为 ${this.chunks.length} 个分片，并发数: ${u.CONCURRENT_UPLOADS}`),this.sendDetailProgress("preparing","检查断点续传..."),await this.checkUploadedChunks(),this.uploadedChunks.forEach(s=>{const i=this.chunks[s];i&&this.updateChunkProgress(s,"completed",100,i.chunkSize)});const e=this.chunks.filter(s=>!this.uploadedChunks.has(s.chunkIndex));if(e.length===0)console.log("所有分片已上传，直接合并"),this.sendDetailProgress("merging","所有分片已存在，正在合并...");else{console.log(`需要上传 ${e.length} 个分片，已完成 ${this.uploadedChunks.size} 个`);const s=u.CONCURRENT_UPLOADS;this.totalBatches=Math.ceil(e.length/s);for(let i=0;i<e.length;i+=s){if(this.aborted)throw new Error("Upload aborted");this.currentBatch=Math.floor(i/s)+1;const o=e.slice(i,i+s),n=Math.round((i+o.length)/e.length*100);console.log(`上传批次 ${this.currentBatch}/${this.totalBatches}，进度: ${n}%`),this.sendDetailProgress("uploading",`上传批次 ${this.currentBatch}/${this.totalBatches}`),await Promise.all(o.map(l=>this.uploadChunkWithRetry(l))),i+s<e.length&&await new Promise(l=>setTimeout(l,200))}}console.log("所有分片上传完成，开始合并文件..."),this.sendDetailProgress("merging","正在合并文件..."),await this.mergeChunks();const t=(Date.now()-this.uploadStartTime)/1e3,r=this.file.size/t/1024/1024;console.log(`文件上传成功！耗时: ${t.toFixed(2)}秒，平均速度: ${r.toFixed(2)} MB/s`),this.onProgress&&this.onProgress(100),this.sendDetailProgress("completed","上传完成！",{percentage:100,uploadedSize:this.file.size})}catch(e){throw console.error("文件上传失败:",e),this.sendDetailProgress("error","上传失败",{errorMessage:e.message}),this.onError&&this.onError(e),e}}static shouldUseChunkUpload(e){return e>10*1024*1024}getProgress(){const e=Array.from(this.uploadedChunks).map(n=>{var l;return((l=this.chunks[n])==null?void 0:l.chunkSize)||0}).reduce((n,l)=>n+l,0),t=this.file.size>0?Math.round(e/this.file.size*100):0,r=Date.now()-this.uploadStartTime,s=r>0?e/r*1e3:0,i=this.file.size-e,o=s>0?i/s:0;return{uploadedChunks:this.uploadedChunks.size,totalChunks:this.chunks.length,uploadedSize:e,totalSize:this.file.size,percentage:t,speed:s,remainingTime:o}}};a(u,"DEFAULT_CHUNK_SIZE",50*1024*1024),a(u,"MIN_CHUNK_SIZE",1*1024*1024),a(u,"MAX_RETRIES",5),a(u,"CONCURRENT_UPLOADS",3),a(u,"CHUNK_UPLOAD_TIMEOUT",3e5),a(u,"RETRY_BASE_DELAY",2e3);let P=u;export{P as ChunkUploader};
//# sourceMappingURL=chunkUpload-CKWji_Pn.js.map
