import { Request, Response, NextFunction } from 'express';
import { AuthManager } from '../modules/auth/AuthManager.js';
export interface AuthenticatedRequest extends Request {
    user?: {
        userId: string;
        username: string;
        role: string;
    };
}
export declare function setAuthManager(manager: AuthManager): void;
export declare function authenticateToken(req: AuthenticatedRequest, res: Response, next: NextFunction): Response<any, Record<string, any>>;
export declare function authenticateTokenFlexible(req: AuthenticatedRequest, res: Response, next: NextFunction): Response<any, Record<string, any>>;
export declare function requireRole(role: string): (req: AuthenticatedRequest, res: Response, next: NextFunction) => Response<any, Record<string, any>>;
export declare function requireAdmin(req: AuthenticatedRequest, res: Response, next: NextFunction): Response<any, Record<string, any>>;
