import logger from '../utils/logger.js';
let authManager;
export function setAuthManager(manager) {
    authManager = manager;
}
export function authenticateToken(req, res, next) {
    const authHeader = req.headers['authorization'];
    const token = authHeader && authHeader.split(' ')[1];
    if (!token) {
        return res.status(401).json({
            error: '访问被拒绝',
            message: '需要提供访问令牌或重新登录'
        });
    }
    if (!authManager) {
        logger.error('认证管理器未初始化');
        return res.status(500).json({
            error: '服务器错误',
            message: '认证服务不可用'
        });
    }
    const decoded = authManager.verifyToken(token);
    if (!decoded) {
        return res.status(401).json({
            error: '访问被拒绝',
            message: '无效或过期的访问令牌，请重新登录'
        });
    }
    req.user = {
        userId: decoded.userId,
        username: decoded.username,
        role: decoded.role
    };
    next();
}
export function authenticateTokenFlexible(req, res, next) {
    const authHeader = req.headers['authorization'];
    let token = authHeader && authHeader.split(' ')[1];
    if (!token) {
        token = req.query.token;
    }
    if (!token) {
        return res.status(401).json({
            error: '访问被拒绝',
            message: '需要提供访问令牌或重新登录'
        });
    }
    if (!authManager) {
        logger.error('认证管理器未初始化');
        return res.status(500).json({
            error: '服务器错误',
            message: '认证服务不可用'
        });
    }
    const decoded = authManager.verifyToken(token);
    if (!decoded) {
        return res.status(401).json({
            error: '访问被拒绝',
            message: '无效或过期的访问令牌，请重新登录'
        });
    }
    req.user = {
        userId: decoded.userId,
        username: decoded.username,
        role: decoded.role
    };
    next();
}
export function requireRole(role) {
    return (req, res, next) => {
        if (!req.user) {
            return res.status(401).json({
                error: '访问被拒绝',
                message: '需要身份验证'
            });
        }
        if (req.user.role !== role && req.user.role !== 'admin') {
            return res.status(403).json({
                error: '访问被拒绝',
                message: '权限不足'
            });
        }
        next();
    };
}
export function requireAdmin(req, res, next) {
    return requireRole('admin')(req, res, next);
}
