import winston from 'winston';
export interface CaptchaData {
    id: string;
    code: string;
    createdAt: string;
    expiresAt: string;
    used: boolean;
}
export interface CaptchaResult {
    id: string;
    svg: string;
}
export declare class CaptchaManager {
    private captchas;
    private captchaFilePath;
    private logger;
    private cleanupInterval;
    constructor(logger: winston.Logger);
    initialize(): Promise<void>;
    private loadCaptchas;
    private saveCaptchas;
    private startCleanupTimer;
    private cleanupExpiredCaptchas;
    generateCaptcha(): CaptchaResult;
    private generateSVG;
    verifyCaptcha(id: string, code: string): boolean;
    destroy(): void;
}
