export interface BackupInfo {
    name: string;
    baseDir: string;
    files: {
        fileName: string;
        size: number;
        modified: string;
    }[];
    totalSize: number;
    meta?: {
        sourcePath?: string;
    };
}
export declare class BackupManager {
    private backupRoot;
    constructor();
    private ensureDir;
    listBackups(): Promise<BackupInfo[]>;
    private formatTimestamp;
    createBackup(backupName: string, sourcePath: string, maxKeep: number): Promise<{
        archivePath: string;
    }>;
    restoreBackup(backupName: string, fileName: string): Promise<{
        targetPath: string;
    }>;
    deleteBackupFile(backupName: string, fileName: string): Promise<void>;
    deleteBackupFolder(backupName: string): Promise<void>;
    getBackupFilePath(backupName: string, fileName: string): Promise<string>;
}
export declare const backupManager: BackupManager;
