import winston from 'winston';
export interface AppConfig {
    jwt: {
        secret: string;
        expiresIn: string;
    };
    auth: {
        maxLoginAttempts: number;
        lockoutDuration: number;
        sessionTimeout: number;
    };
    security: {
        tokenResetRule: 'startup' | 'expire';
        tokenExpireHours: number | null;
    };
    server: {
        port: number;
        host: string;
        corsOrigin: string;
    };
    steamcmd: {
        installMode: 'online' | 'manual';
        installPath: string;
        isInstalled: boolean;
        version?: string;
        lastChecked?: string;
    };
    terminal: {
        defaultUser: string;
    };
    game: {
        defaultInstallPath: string;
    };
    sponsor?: {
        key: string;
        isValid: boolean;
        expiryTime?: string;
        validatedAt: string;
    };
    developer?: {
        passwordHash: string;
        salt: string;
    };
}
export declare class ConfigManager {
    private config;
    private configPath;
    private logger;
    constructor(logger: winston.Logger);
    private getDefaultConfig;
    private generateJWTSecret;
    initialize(): Promise<void>;
    private loadConfig;
    private mergeConfig;
    saveConfig(): Promise<void>;
    getConfig(): AppConfig;
    updateConfig(updates: Partial<AppConfig>): Promise<void>;
    regenerateJWTSecret(): Promise<void>;
    getJWTSecret(): string;
    getJWTConfig(): {
        secret: string;
        expiresIn: string;
    };
    getAuthConfig(): {
        maxLoginAttempts: number;
        lockoutDuration: number;
        sessionTimeout: number;
    };
    getServerConfig(): {
        port: number;
        host: string;
        corsOrigin: string;
    };
    getSteamCMDConfig(): {
        installMode: "online" | "manual";
        installPath: string;
        isInstalled: boolean;
        version?: string;
        lastChecked?: string;
    };
    updateSteamCMDConfig(updates: Partial<AppConfig['steamcmd']>): Promise<void>;
    getTerminalConfig(): {
        defaultUser: string;
    };
    updateTerminalConfig(updates: Partial<AppConfig['terminal']>): Promise<void>;
    getGameConfig(): {
        defaultInstallPath: string;
    };
    updateGameConfig(updates: Partial<AppConfig['game']>): Promise<void>;
    getSponsorConfig(): {
        key: string;
        isValid: boolean;
        expiryTime?: string;
        validatedAt: string;
    };
    updateSponsorConfig(sponsorData: {
        key: string;
        isValid: boolean;
        expiryTime?: string;
    }): Promise<void>;
    clearSponsorConfig(): Promise<void>;
    getDeveloperConfig(): {
        passwordHash: string;
        salt: string;
    };
    hasDeveloperPassword(): boolean;
    setDeveloperPassword(passwordHash: string, salt: string): Promise<void>;
    clearDeveloperConfig(): Promise<void>;
    getSecurityConfig(): {
        tokenResetRule: "startup" | "expire";
        tokenExpireHours: number | null;
    };
    updateSecurityConfig(updates: Partial<AppConfig['security']>): Promise<void>;
    updateJWTConfig(updates: Partial<AppConfig['jwt']>): Promise<void>;
    private checkAndResetTokenOnStartup;
}
