import { Response } from 'express';
import type { DeveloperRequest, DeveloperStatusResponse, DeveloperAuthResponse, ProductionPackageResponse, GameConfigResponse, GameConfigOperationResponse } from '../types/developer.js';
import { DeveloperService } from '../services/DeveloperService.js';
export declare class DeveloperController {
    private developerService;
    constructor(developerService: DeveloperService);
    checkAuthStatus: (req: DeveloperRequest, res: Response<DeveloperStatusResponse>) => Promise<void>;
    setPassword: (req: DeveloperRequest, res: Response<DeveloperAuthResponse>) => Promise<Response<DeveloperAuthResponse, Record<string, any>>>;
    login: (req: DeveloperRequest, res: Response<DeveloperAuthResponse>) => Promise<Response<DeveloperAuthResponse, Record<string, any>>>;
    executeProductionPackage: (req: DeveloperRequest, res: Response<ProductionPackageResponse>) => Promise<Response<ProductionPackageResponse, Record<string, any>>>;
    getGameConfigs: (req: DeveloperRequest, res: Response<GameConfigResponse>) => Promise<void>;
    createGameConfig: (req: DeveloperRequest, res: Response<GameConfigOperationResponse>) => Promise<Response<GameConfigOperationResponse, Record<string, any>>>;
    updateGameConfig: (req: DeveloperRequest, res: Response<GameConfigOperationResponse>) => Promise<Response<GameConfigOperationResponse, Record<string, any>>>;
    deleteGameConfig: (req: DeveloperRequest, res: Response<GameConfigOperationResponse>) => Promise<Response<GameConfigOperationResponse, Record<string, any>>>;
}
