import { Router } from 'express';
import { authenticateToken } from '../../../middleware/auth.js';
import { DeveloperService } from '../services/DeveloperService.js';
import { DeveloperController } from '../controllers/DeveloperController.js';
import { DeveloperAuthMiddleware } from '../middleware/developerAuth.js';
export function createDeveloperRoutes(configManager) {
    const router = Router();
    const developerService = new DeveloperService(configManager);
    const developerController = new DeveloperController(developerService);
    const developerAuthMiddleware = new DeveloperAuthMiddleware(configManager);
    router.use(authenticateToken);
    router.get('/auth/status', developerAuthMiddleware.checkToken, developerController.checkAuthStatus);
    router.post('/auth/set-password', developerController.setPassword);
    router.post('/auth/login', developerController.login);
    router.post('/production-package', developerAuthMiddleware.authenticate, developerController.executeProductionPackage);
    router.get('/game-configs', developerAuthMiddleware.authenticate, developerController.getGameConfigs);
    router.post('/game-configs', developerAuthMiddleware.authenticate, developerController.createGameConfig);
    router.put('/game-configs/:key', developerAuthMiddleware.authenticate, developerController.updateGameConfig);
    router.delete('/game-configs/:key', developerAuthMiddleware.authenticate, developerController.deleteGameConfig);
    return router;
}
export function setupDeveloperRoutes(configManager) {
    return createDeveloperRoutes(configManager);
}
