export interface DirectXEnvironment {
    version: string;
    platform: string;
    downloadUrl: string;
    installed: boolean;
    installPath?: string;
    installing?: boolean;
    installProgress?: number;
    installStage?: 'download' | 'install';
}
export declare class DirectXManager {
    private installDir;
    constructor();
    private ensureInstallDir;
    private getVersionDir;
    private checkDirectXInstalled;
    private checkDirectXWithDxdiag;
    private checkDirectXRegistry;
    private checkDirectXFiles;
    private checkDirectXDLLs;
    private downloadFile;
    private extractDirectXRedist;
    private executeDirectXSetup;
    private executeInstaller;
    private verifyInstallation;
    getDirectXEnvironments(): Promise<DirectXEnvironment[]>;
    installDirectX(downloadUrl: string, onProgress?: (stage: 'download' | 'install', progress: number) => void): Promise<void>;
    uninstallDirectX(): Promise<void>;
    getDirectXInfo(): Promise<{
        version?: string;
        installed: boolean;
        details: string;
    }>;
    private getDirectXVersion;
}
