export interface JavaEnvironment {
    version: string;
    platform: string;
    downloadUrl: string;
    installed: boolean;
    installPath?: string;
    javaExecutable?: string;
}
export declare class JavaManager {
    private readonly installDir;
    constructor();
    private ensureInstallDir;
    private getVersionDir;
    private findJavaExecutable;
    getJavaEnvironments(): Promise<JavaEnvironment[]>;
    isJavaInstalled(version: string): Promise<boolean>;
    private downloadFile;
    private extractFile;
    private setExecutablePermissions;
    installJava(version: string, downloadUrl: string, onProgress?: (stage: 'download' | 'extract', progress: number) => void): Promise<void>;
    uninstallJava(version: string): Promise<void>;
    verifyJava(version: string): Promise<{
        javaPath: string;
        versionInfo: string;
    }>;
    getJavaInfo(version: string): Promise<JavaEnvironment | null>;
}
