export interface PackageInfo {
    name: string;
    description: string;
    category: string;
    installed: boolean;
    installing?: boolean;
}
export interface PackageInstallTask {
    id: string;
    packageName: string;
    packageManager: string;
    operation: 'install' | 'uninstall';
    status: 'preparing' | 'installing' | 'completed' | 'failed';
    startTime: Date;
    endTime?: Date;
    error?: string;
}
export interface PackageManager {
    name: string;
    displayName: string;
    checkCommand: string;
    installCommand: string;
    uninstallCommand: string;
    listCommand: string;
    available: boolean;
}
export declare class LinuxPackageManager {
    private packageManagers;
    private aptPackages;
    constructor();
    private initializePackageManagers;
    getAvailablePackageManagers(): Promise<PackageManager[]>;
    getPackageList(packageManagerName: string): Promise<PackageInfo[]>;
    private getAptPackageList;
    private checkPackageInstalled;
    private checkPackageAvailable;
    private enable32BitArchitecture;
    installPackages(packageManagerName: string, packageNames: string[], onProgress?: (task: PackageInstallTask) => void): Promise<void>;
    uninstallPackages(packageManagerName: string, packageNames: string[], onProgress?: (task: PackageInstallTask) => void): Promise<void>;
}
