export interface VcRedistEnvironment {
    version: string;
    platform: string;
    downloadUrl: string;
    installed: boolean;
    installPath?: string;
    architecture: 'x86' | 'x64' | 'arm64';
}
export declare class VcRedistManager {
    private installDir;
    constructor();
    private normalizeVersion;
    private ensureInstallDir;
    private getVersionDir;
    private checkVcRedistInstalled;
    private getSearchPatterns;
    private fallbackDetection;
    private getSystemFiles;
    getVcRedistEnvironments(): Promise<VcRedistEnvironment[]>;
    private getDownloadUrl;
    private downloadFile;
    installVcRedist(version: string, architecture: string, downloadUrl: string, onProgress?: (stage: 'download' | 'install', progress: number) => void): Promise<void>;
    private executeInstaller;
    uninstallVcRedist(version: string, architecture: string): Promise<void>;
    private getUninstallInfo;
    private isArchitectureMatch;
    private executeUninstaller;
    private parseCommandLine;
    verifyVcRedist(version: string, architecture: string): Promise<{
        installed: boolean;
        registryInfo?: string;
    }>;
}
