import { EventEmitter } from 'events';
import { Socket } from 'socket.io';
import type { Logger } from 'winston';
export declare class FileWatchManager extends EventEmitter {
    private watchedFiles;
    private logger;
    constructor(logger: Logger);
    watchFile(socket: Socket, filePath: string): Promise<boolean>;
    unwatchFile(socket: Socket, filePath: string): void;
    unwatchAllFilesForSocket(socket: Socket): void;
    getWatchStats(): {
        totalFiles: number;
        files: Array<{
            path: string;
            watcherCount: number;
        }>;
    };
    ignoreNextChange(filePath: string): void;
    private socketIoInstance;
    setSocketIO(io: any): void;
    private findSocket;
    cleanup(): void;
}
