export interface DeploymentOptions {
    extractPath: string;
    tempDir?: string;
}
export interface DeploymentResult {
    success: boolean;
    message: string;
    extractPath?: string;
    serverExecutablePath?: string;
}
export interface ApiServerOptions {
    port?: number;
    host?: string;
}
export declare class FactorioDeployer {
    private readonly downloadUrl;
    private readonly defaultTempDir;
    private cancelled;
    private currentProcess?;
    private currentDownloadController?;
    private detectFileFormat;
    cancel(): void;
    isCancelled(): boolean;
    deploy(options: DeploymentOptions): Promise<DeploymentResult>;
    private downloadServer;
    private checkFileIntegrity;
    private extractServer;
    private diagnoseSystemEnvironment;
    private checkCommandAvailable;
    private extractWithSystemCommand;
    private extractZip;
    private extractGzip;
    private extractTar;
    private extractXz;
    private findServerExecutable;
    checkDeployment(extractPath: string): Promise<boolean>;
    getServerVersion(extractPath: string): Promise<string | null>;
}
