export interface ModrinthSearchResponse {
    hits: ModrinthProject[];
    offset: number;
    limit: number;
    total_hits: number;
}
export interface ModrinthProject {
    project_id: string;
    project_type: string;
    slug: string;
    author: string;
    title: string;
    description: string;
    categories: string[];
    display_categories: string[];
    versions: string[];
    downloads: number;
    follows: number;
    icon_url?: string;
    date_created: string;
    date_modified: string;
    latest_version?: string;
    license: string;
    client_side: string;
    server_side: string;
    gallery: string[];
    featured_gallery?: string;
    color?: number;
}
export interface ModrinthIndex {
    formatVersion: number;
    game: string;
    versionId: string;
    name: string;
    summary?: string;
    files: ModrinthFile[];
    dependencies: Record<string, string>;
}
export interface ModrinthFile {
    path: string;
    hashes: {
        sha1: string;
        sha512?: string;
    };
    env?: {
        client?: string;
        server?: string;
    };
    downloads: string[];
    fileSize: number;
}
export interface ModpackSearchOptions {
    query?: string;
    categories?: string[];
    versions?: string[];
    license?: string;
    project_type?: string;
    limit?: number;
    offset?: number;
    index?: string;
}
export interface ModpackDeployOptions {
    mrpackUrl: string;
    targetDirectory: string;
    minecraftVersion?: string;
    loaderType?: 'forge' | 'neoforge' | 'fabric' | 'quilt';
    skipJavaCheck?: boolean;
    tempDir?: string;
    onProgress?: (message: string, type?: 'info' | 'error' | 'success' | 'warn') => void;
}
export interface ModpackDeployResult {
    success: boolean;
    message: string;
    targetDirectory?: string;
    installedMods?: number;
    loaderVersion?: string;
    serverType?: string;
}
export declare class MrpackServerAPI {
    private static readonly MODRINTH_API_BASE;
    private static readonly SEARCH_ENDPOINT;
    private tempDir;
    private cancelled;
    private currentProcess?;
    constructor(tempDir?: string);
    searchModpacks(options?: ModpackSearchOptions): Promise<ModrinthSearchResponse>;
    getProjectVersions(projectId: string): Promise<any[]>;
    downloadAndParseMrpack(mrpackUrl: string): Promise<ModrinthIndex>;
    private extractModrinthIndex;
    private extractOverrides;
    private downloadMods;
    cancel(): void;
    isCancelled(): boolean;
    deployModpack(options: ModpackDeployOptions): Promise<ModpackDeployResult>;
    private detectLoaderType;
    private getServerName;
    private moveFilesToTarget;
    private isForgeInstaller;
    private runForgeInstallerWithCancel;
    private runServerUntilEulaWithCancel;
    private runForgeServerWithCancel;
    cleanup(): Promise<void>;
}
export default MrpackServerAPI;
