export interface GameConfigField {
    name: string;
    display: string;
    default: any;
    type: 'string' | 'number' | 'boolean' | 'select' | 'nested';
    description?: string;
    options?: Array<{
        value: any;
        label: string;
    }>;
    nested_fields?: GameConfigField[];
}
export interface GameConfigSection {
    key: string;
    fields: GameConfigField[];
}
export interface GameConfigMeta {
    game_name: string;
    config_file: string;
    parser?: string;
}
export interface GameConfigSchema {
    meta: GameConfigMeta;
    sections: GameConfigSection[];
}
export interface ParsedConfigData {
    [sectionKey: string]: {
        [fieldName: string]: any;
    };
}
export declare class GameConfigManager {
    private configSchemasDir;
    private supportedParsers;
    private configsCache;
    constructor();
    getAvailableGameConfigs(): Promise<GameConfigSchema[]>;
    getGameConfigSchema(gameName: string): Promise<GameConfigSchema | null>;
    readGameConfig(serverPath: string, configSchema: GameConfigSchema): Promise<ParsedConfigData>;
    saveGameConfig(serverPath: string, configSchema: GameConfigSchema, configData: ParsedConfigData): Promise<boolean>;
    getDefaultValues(configSchema: GameConfigSchema): ParsedConfigData;
    private parseWithProperties;
    private parseWithConfigObj;
    private parseWithYaml;
    private parseWithJson;
    private parseNestedValue;
    private convertValue;
    private saveWithProperties;
    private saveWithConfigObj;
    private saveWithYaml;
    private saveWithJson;
    private formatNestedValue;
    private parseWithToml;
    private saveWithToml;
}
