import winston from 'winston';
export interface Plugin {
    name: string;
    displayName: string;
    description: string;
    version: string;
    author: string;
    enabled: boolean;
    hasWebInterface: boolean;
    entryPoint?: string;
    icon?: string;
    category?: string;
}
export interface PluginConfig {
    name: string;
    displayName: string;
    description: string;
    version: string;
    author: string;
    enabled: boolean;
    hasWebInterface: boolean;
    entryPoint?: string;
    icon?: string;
    category?: string;
}
export declare class PluginManager {
    private plugins;
    private pluginsDir;
    private logger;
    constructor(logger: winston.Logger);
    private initializePluginsDirectory;
    loadPlugins(): Promise<void>;
    private loadPlugin;
    private createDefaultPluginConfig;
    getPlugins(): Plugin[];
    getPlugin(name: string): Plugin | undefined;
    enablePlugin(name: string): Promise<boolean>;
    disablePlugin(name: string): Promise<boolean>;
    private savePluginConfig;
    createPlugin(name: string, config: Partial<PluginConfig>): Promise<boolean>;
    deletePlugin(name: string): Promise<boolean>;
    getPluginPath(name: string): string;
    cleanup(): void;
}
