import { EventEmitter } from 'events';
import winston from 'winston';
import { GameManager } from '../game/GameManager.js';
import { InstanceManager } from '../instance/InstanceManager.js';
import { TerminalManager } from '../terminal/TerminalManager.js';
export interface ScheduledTask {
    id: string;
    name: string;
    type: 'power' | 'command' | 'backup' | 'system';
    instanceId?: string;
    instanceName?: string;
    action?: 'start' | 'stop' | 'restart';
    command?: string;
    backupSourcePath?: string;
    backupName?: string;
    maxKeep?: number;
    checkInstanceRunning?: boolean;
    systemAction?: 'steam_update';
    schedule: string;
    enabled: boolean;
    nextRun?: string;
    lastRun?: string;
    createdAt: string;
    updatedAt: string;
    isSystemTask?: boolean;
}
export declare class SchedulerManager extends EventEmitter {
    private tasks;
    private configPath;
    private logger;
    private gameManager;
    private instanceManager;
    private terminalManager;
    constructor(dataDir: string, logger: winston.Logger);
    setGameManager(gameManager: GameManager): void;
    setInstanceManager(instanceManager: InstanceManager): void;
    setTerminalManager(terminalManager: TerminalManager): void;
    private initializeSystemTasks;
    private loadTasks;
    private saveTasks;
    private scheduleTask;
    private unscheduleTask;
    private executeTask;
    private executeTaskDirectly;
    private executePowerAction;
    private executeCommand;
    private executeBackup;
    private executeSystemAction;
    private updateSteamGameList;
    private getNextRunTime;
    createTask(taskData: Omit<ScheduledTask, 'id' | 'createdAt' | 'updatedAt'>): Promise<ScheduledTask>;
    updateTask(taskId: string, updates: Partial<ScheduledTask>): Promise<ScheduledTask>;
    deleteTask(taskId: string): Promise<void>;
    toggleTask(taskId: string, enabled: boolean): Promise<ScheduledTask>;
    getTasks(): ScheduledTask[];
    getTask(taskId: string): ScheduledTask | undefined;
    executeTaskImmediately(taskId: string): Promise<void>;
    destroy(): void;
}
