import winston from 'winston';
import { ConfigManager } from '../config/ConfigManager.js';
export interface SteamCMDInstallOptions {
    installPath: string;
    onProgress?: (progress: number) => void;
    onStatusChange?: (status: string) => void;
}
export interface SteamCMDStatus {
    isInstalled: boolean;
    version?: string;
    installPath?: string;
    lastChecked?: string;
}
export declare class SteamCMDManager {
    private logger;
    private configManager;
    private readonly WINDOWS_DOWNLOAD_URL;
    private readonly LINUX_DOWNLOAD_URL;
    constructor(logger: winston.Logger, configManager: ConfigManager);
    getStatus(): Promise<SteamCMDStatus>;
    checkSteamCMDExists(installPath: string): Promise<boolean>;
    installOnline(options: SteamCMDInstallOptions): Promise<void>;
    setManualPath(installPath: string): Promise<boolean>;
    private downloadFile;
    private extractZip;
    private extractTarGz;
    getSteamCMDExecutablePath(): Promise<string | null>;
    refreshStatus(): Promise<SteamCMDStatus>;
}
