import { Server as SocketIOServer } from 'socket.io';
import winston from 'winston';
import { EventEmitter } from 'events';
interface SystemInfo {
    platform: string;
    rawPlatform: string;
    arch: string;
    hostname: string;
    ipv4: string[];
    ipv6: string[];
    uptime: number;
    totalMemory: number;
    freeMemory: number;
    cpuCount: number;
    cpuModel: string;
    nodeVersion: string;
    serverVersion: string;
    serverUptime: number;
}
interface SystemStats {
    timestamp: Date;
    cpu: {
        usage: number;
        cores: number;
        model: string;
        speed: number;
        coreUsages: number[];
    };
    memory: {
        total: number;
        used: number;
        free: number;
        usage: number;
        committed?: number;
        commitLimit?: number;
        swap?: {
            total: number;
            used: number;
            free: number;
            usage: number;
        };
        available?: number;
        buffers?: number;
        cached?: number;
    };
    disk: {
        total: number;
        used: number;
        free: number;
        usage: number;
        readBytes: number;
        writeBytes: number;
        readOps: number;
        writeOps: number;
    };
    network: {
        rx: number;
        tx: number;
    };
    processes: {
        total: number;
        running: number;
        sleeping: number;
    };
    load: {
        avg1: number;
        avg5: number;
        avg15: number;
    };
    panel: {
        cpu: number;
        memory: number;
        memoryUsage: number;
        uptime: number;
        pid: number;
    };
}
interface ProcessInfoResponse {
    id: string;
    pid: number;
    name: string;
    cpu: number;
    memory: number;
    status: string;
    startTime: string;
    command: string;
}
interface DiskInfo {
    filesystem: string;
    size: number;
    used: number;
    available: number;
    usage: number;
    mountpoint: string;
}
interface NetworkInterface {
    name: string;
    address: string;
    netmask: string;
    family: string;
    mac: string;
    internal: boolean;
    cidr: string;
}
interface ActivePort {
    port: number;
    protocol: 'tcp' | 'udp';
    state: string;
    process?: string;
    pid?: number;
    address: string;
}
interface SystemAlert {
    id: string;
    type: 'cpu' | 'memory' | 'disk' | 'network' | 'process';
    level: 'info' | 'warning' | 'critical';
    message: string;
    value: number;
    threshold: number;
    timestamp: Date;
    resolved: boolean;
}
interface AlertThresholds {
    cpu: {
        warning: number;
        critical: number;
    };
    memory: {
        warning: number;
        critical: number;
    };
    disk: {
        warning: number;
        critical: number;
    };
    network: {
        warning: number;
        critical: number;
    };
}
export declare class SystemManager extends EventEmitter {
    private io;
    private logger;
    private serverStartTime;
    private statsHistory;
    private alerts;
    private alertThresholds;
    private monitoringInterval?;
    private portsMonitoringInterval?;
    private processesMonitoringInterval?;
    private lastNetworkStats;
    private lastDiskStats;
    private selectedDisk;
    private selectedNetworkInterface;
    private resourceMethods;
    constructor(io: SocketIOServer, logger: winston.Logger);
    private detectResourceMethods;
    private startMonitoring;
    private hasSubscribers;
    private stopMonitoring;
    private getLocalIpAddresses;
    getSystemInfo(): Promise<SystemInfo>;
    private collectSystemStats;
    private lastCpuUsage;
    private lastCpuTime;
    private getPanelResourceUsage;
    private getCpuUsage;
    private getMemoryInfo;
    private getWindowsMemoryInfo;
    private getWindowsMemoryInfoByPowerShell;
    private getWindowsMemoryInfoByWmic;
    private getWindowsMemoryInfoFallback;
    private getLinuxMemoryInfo;
    private getDiskInfo;
    private getWindowsDiskInfo;
    private getWindowsDiskInfoByPowerShell;
    private getWindowsDiskInfoByWmic;
    private getWindowsDiskInfoFallback;
    private getLinuxDiskInfo;
    private getNetworkInfo;
    private getWindowsNetworkStats;
    private getLinuxNetworkStats;
    private getProcessInfo;
    private getLoadInfo;
    getNetworkInterfaces(): NetworkInterface[];
    getDiskList(): Promise<DiskInfo[]>;
    private getWindowsDiskList;
    private getLinuxDiskList;
    getProcessList(): Promise<ProcessInfoResponse[]>;
    private getWindowsProcessList;
    private getWindowsProcessListByPowerShell;
    private getWindowsProcessListByWmic;
    private getWindowsProcessListFallback;
    private getLinuxProcessList;
    killProcess(pid: number, force?: boolean): Promise<{
        success: boolean;
        message: string;
    }>;
    private checkProcessExists;
    private checkAlerts;
    private checkAlert;
    getStatsHistory(minutes?: number): SystemStats[];
    getActiveAlerts(): SystemAlert[];
    setAlertThresholds(thresholds: Partial<AlertThresholds>): void;
    private parseSize;
    getActivePorts(): Promise<ActivePort[]>;
    setSelectedDisk(disk: string): void;
    getSelectedDisk(): string;
    setSelectedNetworkInterface(interfaceName: string): void;
    getSelectedNetworkInterface(): string;
    getAvailableNetworkInterfaces(): {
        name: string;
        displayName: string;
        type: string;
    }[];
    handleClientDisconnect(): void;
    cleanup(): void;
}
export {};
