import { Server as SocketIOServer } from 'socket.io';
declare const router: import("express-serve-static-core").Router;
export declare function setMoreGamesDependencies(socketIO: SocketIOServer): void;
export declare enum GameType {
    TMODLOADER = "tmodloader",
    FACTORIO = "factorio",
    MRPACK = "mrpack",
    BEDROCK = "bedrock"
}
export declare enum Platform {
    WINDOWS = "windows",
    LINUX = "linux",
    MACOS = "macos"
}
export interface GameInfo {
    id: string;
    name: string;
    description: string;
    icon: string;
    category: string;
    supported: boolean;
    supportedPlatforms: Platform[];
}
export interface DeploymentOptions {
    gameType: GameType;
    installPath: string;
    options?: any;
}
export interface DeploymentResult {
    success: boolean;
    message: string;
    data?: any;
}
export default router;
