import { ConfigManager } from '../modules/config/ConfigManager.js';
import { Server as SocketIOServer } from 'socket.io';
declare const router: import("express-serve-static-core").Router;
export declare function setOnlineDeployDependencies(socketIO: SocketIOServer, config: ConfigManager): void;
export declare enum Platform {
    WINDOWS = "windows",
    LINUX = "linux",
    MACOS = "macos"
}
export interface OnlineGameInfo {
    id: string;
    name: string;
    description?: string;
    image?: string;
    downloadUrl?: string;
    type?: string[];
    category?: string;
    supportedPlatforms: Platform[];
    deploymentScript?: string;
    version?: string;
}
export interface OnlineDeploymentOptions {
    gameId: string;
    installPath: string;
    options?: any;
}
export interface OnlineDeploymentResult {
    success: boolean;
    message: string;
    data?: any;
}
export default router;
