import winston from 'winston';
import { ConfigManager } from '../config/ConfigManager.js';
export interface User {
    id: string;
    username: string;
    password: string;
    role: 'admin' | 'user';
    createdAt: string;
    lastLogin?: string;
    loginAttempts: number;
    lockedUntil?: string;
}
export interface LoginAttempt {
    username: string;
    ip: string;
    timestamp: string;
    success: boolean;
}
export interface AuthResult {
    success: boolean;
    token?: string;
    user?: Omit<User, 'password'>;
    message: string;
    requireCaptcha?: boolean;
}
export declare class AuthManager {
    private users;
    private loginAttempts;
    private usersFilePath;
    private attemptsFilePath;
    private logger;
    private configManager;
    private captchaManager;
    private failedAttempts;
    constructor(configManager: ConfigManager, logger: winston.Logger);
    initialize(): Promise<void>;
    private loadUsers;
    private loadLoginAttempts;
    private saveUsers;
    private saveLoginAttempts;
    private createDefaultAdmin;
    login(username: string, password: string, ip: string, captchaId?: string, captchaCode?: string): Promise<AuthResult>;
    verifyToken(token: string): any;
    changePassword(username: string, oldPassword: string, newPassword: string): Promise<{
        success: boolean;
        message: string;
    }>;
    changeUsername(currentUsername: string, newUsername: string): Promise<{
        success: boolean;
        message: string;
    }>;
    getUsers(): Omit<User, 'password'>[];
    getLoginAttempts(limit?: number): LoginAttempt[];
    generateCaptcha(): import("./CaptchaManager.js").CaptchaResult;
    checkIfRequireCaptcha(username: string): boolean;
    hasUsers(): boolean;
    register(username: string, password: string, role?: 'admin' | 'user'): Promise<{
        success: boolean;
        message: string;
        user?: Omit<User, 'password'>;
    }>;
}
