export interface ChunkUpload {
    uploadId: string;
    fileName: string;
    fileSize: number;
    totalChunks: number;
    uploadedChunks: Set<number>;
    chunks: Map<number, ChunkInfo>;
    targetPath: string;
    createdAt: number;
    lastActivity: number;
}
export interface ChunkInfo {
    chunkIndex: number;
    chunkSize: number;
    chunkHash: string;
    filePath: string;
    uploaded: boolean;
}
export declare class ChunkUploadManager {
    private static instance;
    private uploads;
    private readonly CHUNK_DIR;
    private readonly CLEANUP_INTERVAL;
    private readonly MAX_UPLOAD_AGE;
    private constructor();
    static getInstance(): ChunkUploadManager;
    private ensureChunkDir;
    private getUploadDir;
    private getChunkPath;
    getOrCreateUpload(uploadId: string, fileName: string, fileSize: number, totalChunks: number, targetPath: string): Promise<ChunkUpload>;
    saveChunk(uploadId: string, chunkIndex: number, chunkData: Buffer, chunkHash: string): Promise<void>;
    isUploadComplete(uploadId: string): boolean;
    mergeChunks(uploadId: string, targetFilePath: string): Promise<void>;
    getUploadedChunks(uploadId: string): number[];
    cleanupUpload(uploadId: string): Promise<void>;
    private startCleanupTimer;
    cancelUpload(uploadId: string): Promise<void>;
}
