import type { ConfigManager } from '../../config/ConfigManager.js';
import type { DeveloperAuth, DeveloperJWTPayload, ProductionPackageResult, GameConfig, GameConfigData } from '../types/developer.js';
export declare class DeveloperService {
    private configManager;
    constructor(configManager: ConfigManager);
    checkAuthStatus(userPayload?: DeveloperJWTPayload): Promise<DeveloperAuth>;
    setPassword(password: string): Promise<string>;
    login(password: string): Promise<string>;
    executeProductionPackage(): Promise<ProductionPackageResult>;
    private getInstallGameJsonPath;
    getGameConfigs(): Promise<GameConfigData>;
    private saveGameConfigs;
    createGameConfig(config: GameConfig): Promise<GameConfig>;
    updateGameConfig(key: string, configData: Omit<GameConfig, 'key'>): Promise<GameConfig>;
    deleteGameConfig(key: string): Promise<void>;
    private generateToken;
}
