import { Request } from 'express';
export interface DeveloperAuth {
    isAuthenticated: boolean;
    hasPassword: boolean;
}
export interface DeveloperConfig {
    passwordHash: string;
    salt: string;
    createdAt: Date;
    updatedAt: Date;
}
export interface DeveloperJWTPayload {
    type: 'developer';
    timestamp: number;
    exp?: number;
    iat?: number;
}
export interface DeveloperRequest extends Request {
    user?: DeveloperJWTPayload;
}
export interface ProductionPackageResult {
    deletedFiles: number;
    preservedDirs: number;
    preservedFiles: number;
    dataDir: string;
}
export interface ApiResponse<T = any> {
    success: boolean;
    data?: T;
    message?: string;
}
export interface DeveloperAuthResponse extends ApiResponse<{
    token: string;
}> {
}
export interface DeveloperStatusResponse extends ApiResponse<DeveloperAuth> {
}
export interface ProductionPackageResponse extends ApiResponse<ProductionPackageResult> {
}
export interface GameConfig {
    key: string;
    game_nameCN: string;
    appid: string;
    tip: string;
    image: string;
    url: string;
    system?: string[];
    system_info?: string[];
    memory?: number;
    docs?: string;
    ports?: Array<{
        port: number;
        protocol: string;
    }>;
}
export interface GameConfigData {
    [key: string]: Omit<GameConfig, 'key'>;
}
export interface GameConfigResponse extends ApiResponse<GameConfigData> {
}
export interface GameConfigOperationResponse extends ApiResponse<GameConfig> {
}
