import { Server as SocketIOServer, Socket } from 'socket.io';
import winston from 'winston';
import { EventEmitter } from 'events';
interface GameConfig {
    id: string;
    name: string;
    type: 'minecraft' | 'terraria' | 'custom';
    executable: string;
    args: string[];
    workingDirectory: string;
    autoStart: boolean;
    autoRestart: boolean;
    maxMemory?: string;
    minMemory?: string;
    javaPath?: string;
    port?: number;
    maxPlayers?: number;
    description?: string;
    icon?: string;
    createdAt: Date;
    updatedAt: Date;
}
interface GameTemplate {
    id: string;
    name: string;
    type: 'minecraft' | 'terraria' | 'custom';
    description: string;
    icon: string;
    defaultConfig: Partial<GameConfig>;
    setupSteps: string[];
}
export declare class GameManager extends EventEmitter {
    private games;
    private io;
    private logger;
    private configPath;
    private templates;
    constructor(io: SocketIOServer, logger: winston.Logger);
    private initializeTemplates;
    getTemplates(): GameTemplate[];
    createGame(socket: Socket, config: Omit<GameConfig, 'id' | 'createdAt' | 'updatedAt'>): Promise<void>;
    startGame(socket: Socket, gameId: string): Promise<void>;
    stopGame(socket: Socket, gameId: string): Promise<void>;
    restartGame(socket: Socket, gameId: string): Promise<void>;
    startGameById(gameId: string): Promise<void>;
    stopGameById(gameId: string): Promise<void>;
    restartGameById(gameId: string): Promise<void>;
    sendCommand(socket: Socket, gameId: string, command: string): void;
    sendCommandById(gameId: string, command: string): Promise<void>;
    deleteGame(socket: Socket, gameId: string): Promise<void>;
    getGames(): any[];
    private getGameInfo;
    private parseGameOutput;
    private parseMinecraftOutput;
    private addGameLog;
    private updateGameStats;
    private saveGameConfig;
    private deleteGameConfig;
    private loadGameConfigs;
    cleanup(): void;
}
export {};
