export interface ApiResponse<T> {
    code: number;
    message: string;
    data: T;
}
export interface ServerClassifyData {
    pluginsCore: string[];
    pluginsAndModsCore_Forge: string[];
    pluginsAndModsCore_Fabric: string[];
    modsCore_Forge: string[];
    modsCore_Fabric: string[];
    vanillaCore: string[];
    bedrockCore: string[];
    proxyCore: string[];
}
export interface VersionListData {
    versionList: string[];
}
export interface DownloadData {
    url: string;
    sha256: string;
}
export interface ServerCategory {
    name: string;
    displayName: string;
    servers: string[];
}
export interface DownloadOptions {
    server: string;
    version: string;
    targetDirectory?: string;
    skipJavaCheck?: boolean;
    skipServerRun?: boolean;
    silent?: boolean;
}
export interface DownloadProgress {
    loaded: number;
    total: number;
    percentage: number;
}
export type ProgressCallback = (progress: DownloadProgress) => void;
export type LogCallback = (message: string, type?: 'info' | 'error' | 'success' | 'warn') => void;
export declare class ApiService {
    private static readonly BASE_URL;
    static getServerClassify(): Promise<ServerClassifyData>;
    static getAvailableVersions(server: string): Promise<string[]>;
    static getDownloadUrl(server: string, version: string): Promise<DownloadData>;
    static downloadFile(url: string, filePath: string, onProgress?: ProgressCallback, onLog?: LogCallback): Promise<void>;
}
export declare class FileManager {
    private static tempDir;
    static normalizePath(inputPath: string): string;
    static checkDirectoryPermissions(dirPath: string): Promise<boolean>;
    static createTempDirectory(): Promise<string>;
    static getServerJarPath(server: string, version: string): string;
    static fileExists(filePath: string): Promise<boolean>;
    static isForgeInstaller(jarPath: string): boolean;
    static runForgeInstaller(jarPath: string, onLog?: LogCallback): Promise<void>;
    static runForgeServer(serverDir: string, onLog?: LogCallback): Promise<void>;
    static runServerUntilEula(jarPath: string, onLog?: LogCallback): Promise<void>;
    static moveFilesToTarget(targetDir: string, onLog?: LogCallback): Promise<void>;
    static cleanupTempDirectory(onLog?: LogCallback): Promise<void>;
    static forceCleanupDirectory(dirPath: string, onLog?: LogCallback): Promise<void>;
    static getTempDirectory(): string;
    static validateJavaEnvironment(): Promise<boolean>;
}
export declare class MinecraftServerDownloader {
    private onProgress?;
    private onLog?;
    private cancelled;
    private currentProcess?;
    private tempDir?;
    constructor(onProgress?: ProgressCallback, onLog?: LogCallback);
    cancel(): void;
    isCancelled(): boolean;
    downloadServer(options: DownloadOptions): Promise<void>;
    getServerCategories(): Promise<ServerCategory[]>;
    getAvailableVersions(server: string): Promise<string[]>;
    getDownloadInfo(server: string, version: string): Promise<DownloadData>;
    private runForgeInstallerWithCancel;
    private runServerUntilEulaWithCancel;
    validateJava(): Promise<boolean>;
    private formatServerCategories;
}
export declare function downloadMinecraftServer(server: string, version: string, targetDirectory?: string, options?: Partial<DownloadOptions>): Promise<void>;
export declare function getServerCategories(): Promise<ServerCategory[]>;
export declare function getAvailableVersions(server: string): Promise<string[]>;
export declare function getDownloadInfo(server: string, version: string): Promise<DownloadData>;
export declare function validateJavaEnvironment(): Promise<boolean>;
export default MinecraftServerDownloader;
