export interface TModDownloaderOptions {
    downloadDir?: string;
    extractDir?: string;
    deleteAfterExtract?: boolean;
    clearExtractDir?: boolean;
    createVersionDir?: boolean;
}
export declare class TModDownloader {
    private readonly githubApiUrl;
    private readonly fileName;
    private options;
    private cancelled;
    private currentDownloadController?;
    constructor(options?: TModDownloaderOptions);
    private getLatestReleaseInfo;
    private getLatestDownloadUrl;
    private clearDirectory;
    private getFinalExtractDir;
    private getLatestDownloadUrlLegacy;
    cancel(): void;
    isCancelled(): boolean;
    private downloadFile;
    private extractZip;
    private checkAndDeleteExistingZip;
    downloadAndExtract(): Promise<void>;
    getOptions(): Required<TModDownloaderOptions>;
    updateOptions(options: Partial<TModDownloaderOptions>): void;
    getVersionInfo(): Promise<{
        version: string;
        downloadUrl: string;
    }>;
    setExtractDir(extractDir: string): void;
    getCurrentExtractDir(): Promise<string>;
    private cleanupDirectory;
}
export declare function downloadTModLoader(options?: TModDownloaderOptions): Promise<void>;
export declare function getLatestTModLoaderInfo(): Promise<{
    version: string;
    downloadUrl: string;
}>;
