import { EventEmitter } from 'events';
import { TerminalManager } from '../terminal/TerminalManager.js';
export type InstanceType = 'generic' | 'minecraft-java' | 'minecraft-bedrock';
export interface Instance {
    id: string;
    name: string;
    description: string;
    workingDirectory: string;
    startCommand: string;
    autoStart: boolean;
    stopCommand: 'ctrl+c' | 'stop' | 'exit' | 'quit';
    status: 'running' | 'stopped' | 'starting' | 'stopping' | 'error';
    pid?: number;
    createdAt: string;
    lastStarted?: string;
    lastStopped?: string;
    enableStreamForward?: boolean;
    programPath?: string;
    terminalSessionId?: string;
    terminalUser?: string;
    instanceType?: InstanceType;
    javaVersion?: string;
}
export interface CreateInstanceRequest {
    name: string;
    description: string;
    workingDirectory: string;
    startCommand: string;
    autoStart: boolean;
    stopCommand: 'ctrl+c' | 'stop' | 'exit' | 'quit';
    enableStreamForward?: boolean;
    programPath?: string;
    terminalUser?: string;
    instanceType?: InstanceType;
    javaVersion?: string;
}
export declare class InstanceManager extends EventEmitter {
    private instances;
    private configPath;
    private saveTimeout;
    private logger;
    private terminalManager;
    private javaManager;
    constructor(terminalManager: TerminalManager, logger: any, configPath?: string);
    private getSystemLoad;
    private getCpuUsage;
    private waitForLoadDecrease;
    private delay;
    private detectStartScript;
    private detectJarFile;
    private getJavaPath;
    initialize(): Promise<void>;
    private loadInstances;
    private saveInstances;
    private startAutoStartInstances;
    getInstances(): Instance[];
    getInstance(id: string): Instance | undefined;
    createInstance(data: CreateInstanceRequest): Promise<Instance>;
    updateInstance(id: string, data: CreateInstanceRequest): Promise<Instance | null>;
    deleteInstance(id: string): Promise<boolean>;
    startInstance(id: string): Promise<{
        success: boolean;
        terminalSessionId?: string;
    }>;
    restartInstance(id: string): Promise<{
        success: boolean;
        terminalSessionId?: string;
    }>;
    stopInstance(id: string): Promise<boolean>;
    closeTerminal(id: string): Promise<boolean>;
    getInstanceStatus(id: string): {
        status: string;
        pid?: number;
    } | null;
    sendInput(id: string, input: string): boolean;
    cleanup(): Promise<void>;
}
export default InstanceManager;
