import { EventEmitter } from 'events';
export interface RconConfig {
    host: string;
    port: number;
    password: string;
    timeout?: number;
}
export declare enum RconStatus {
    DISCONNECTED = "disconnected",
    CONNECTING = "connecting",
    CONNECTED = "connected",
    AUTHENTICATED = "authenticated",
    ERROR = "error"
}
export declare class RconManager extends EventEmitter {
    private socket;
    private status;
    private config;
    private requestId;
    private pendingRequests;
    private buffer;
    constructor();
    connect(config: RconConfig): Promise<void>;
    disconnect(): void;
    private cleanup;
    private authenticate;
    executeCommand(command: string): Promise<string>;
    private createPacket;
    private sendPacket;
    private handleData;
    private parsePacket;
    private handlePacket;
    getStatus(): RconStatus;
    getConfig(): RconConfig | null;
    isConnected(): boolean;
}
export default RconManager;
