import { EventEmitter } from 'events';
export interface Task {
    id: string;
    type: 'compress' | 'extract' | 'copy' | 'move' | 'download';
    status: 'pending' | 'running' | 'completed' | 'failed';
    progress: number;
    message: string;
    createdAt: Date;
    updatedAt: Date;
    data: any;
}
export declare class TaskManager extends EventEmitter {
    private tasks;
    private dataDir;
    constructor();
    private ensureDataDir;
    createTask(type: 'compress' | 'extract' | 'copy' | 'move' | 'download', data: any): string;
    updateTask(id: string, updates: Partial<Task>): void;
    getTask(id: string): Task | undefined;
    getAllTasks(): Task[];
    getActiveTasks(): Task[];
    deleteTask(id: string): void;
    cleanupTasks(): void;
}
export declare const taskManager: TaskManager;
