import { Server as SocketIOServer, Socket } from 'socket.io';
import winston from 'winston';
import { PersistedTerminalSession } from './TerminalSessionManager.js';
import { ConfigManager } from '../config/ConfigManager.js';
interface CreatePtyData {
    sessionId: string;
    name?: string;
    cols: number;
    rows: number;
    workingDirectory?: string;
    enableStreamForward?: boolean;
    programPath?: string;
    autoCloseOnForwardExit?: boolean;
    terminalUser?: string;
}
interface TerminalInputData {
    sessionId: string;
    data: string;
}
interface TerminalResizeData {
    sessionId: string;
    cols: number;
    rows: number;
}
export declare class TerminalManager {
    private sessions;
    private io;
    private logger;
    private ptyPath;
    private sessionManager;
    private configManager;
    constructor(io: SocketIOServer, logger: winston.Logger, configManager: ConfigManager);
    initialize(): Promise<void>;
    createPty(socket: Socket, data: CreatePtyData): Promise<void>;
    private forceKillProcess;
    restartStreamForwardProcess(sessionId: string): boolean;
    private startStreamForwardProcess;
    handleInput(socket: Socket, data: TerminalInputData): void;
    resizeTerminal(socket: Socket, data: TerminalResizeData): void;
    closePty(socket: Socket, data: {
        sessionId: string;
    }): void;
    handleDisconnect(socket: Socket): void;
    private cleanupInactiveSessions;
    reconnectSession(socket: Socket, sessionId: string): boolean;
    updateSessionName(sessionId: string, newName: string): Promise<boolean>;
    getActiveSessions(): Array<{
        id: string;
        name: string;
        workingDirectory: string;
        createdAt: Date;
        lastActivity: Date;
        hasStreamForward: boolean;
        streamForwardStatus: string;
    }>;
    private getStreamForwardStatus;
    private getSessionStatusInfo;
    getSessionStats(): {
        total: number;
        sessions: Array<{
            id: string;
            name: string;
            createdAt: Date;
            lastActivity: Date;
            disconnected?: boolean;
        }>;
    };
    getSavedSessions(): PersistedTerminalSession[];
    getActiveTerminalProcesses(): Promise<Array<{
        id: string;
        name: string;
        pid: number;
        cpu: number;
        memory: number;
        status: string;
        createdAt: string;
        command: string;
    }>>;
    private getProcessStats;
    private checkCommandExists;
    private checkUserExists;
    private setDirectoryPermissions777;
    private detectControlCharacter;
    private createPtyFallback;
    cleanup(): void;
    private activeProcessesInterval?;
    setSocketIO(io: SocketIOServer): void;
    private startActiveProcessesMonitoring;
    private stopActiveProcessesMonitoring;
    sendActiveProcessesToClient(socket: Socket): Promise<void>;
    handleClientDisconnect(): void;
}
export {};
