import winston from 'winston';
export interface PersistedTerminalSession {
    id: string;
    name: string;
    workingDirectory: string;
    createdAt: string;
    lastActivity: string;
    isActive: boolean;
}
export declare class TerminalSessionManager {
    private configDir;
    private configPath;
    private logger;
    private config;
    constructor(logger: winston.Logger);
    initialize(): Promise<void>;
    private ensureConfigDirectory;
    private loadConfig;
    private saveConfig;
    saveSession(sessionData: {
        id: string;
        name: string;
        workingDirectory: string;
        createdAt: Date;
        lastActivity: Date;
        isActive: boolean;
    }): Promise<void>;
    updateSessionName(sessionId: string, newName: string): Promise<void>;
    removeSession(sessionId: string): Promise<void>;
    getSavedSessions(): PersistedTerminalSession[];
    getSession(sessionId: string): PersistedTerminalSession | undefined;
    cleanupExpiredSessions(): Promise<void>;
    setSessionActive(sessionId: string, isActive: boolean): Promise<void>;
    getConfigPath(): string;
}
