import { exec } from 'child_process';
import { promisify } from 'util';
const execPromise = promisify(exec);
export async function execAsync(command, options) {
    const result = await execPromise(command, { encoding: 'utf8', ...options });
    return {
        stdout: result.stdout.toString(),
        stderr: result.stderr.toString()
    };
}
export default execAsync;
