import * as tar from 'tar';
export interface TarSecurityFilterOptions {
    cwd: string;
    blockSymbolicLinks?: boolean;
    blockHardLinks?: boolean;
    verbose?: boolean;
}
export declare function createTarSecurityFilter(options: TarSecurityFilterOptions): (filePath: string, entry: tar.ReadEntry) => boolean;
export declare function createSimpleTarSecurityFilter(cwd: string): (filePath: string, entry: tar.ReadEntry) => boolean;
export declare function createSafeTarExtractOptions(file: string, cwd: string, additionalOptions?: Partial<tar.ExtractOptions>): tar.ExtractOptions;
declare const _default: {
    createTarSecurityFilter: typeof createTarSecurityFilter;
    createSimpleTarSecurityFilter: typeof createSimpleTarSecurityFilter;
    createSafeTarExtractOptions: typeof createSafeTarExtractOptions;
};
export default _default;
